import unittest
import os
import tempfile
import symfer as s

doms = {'A':2, 'B':3, 'C':5, 'D':3}


class TestYaml(unittest.TestCase):
    '''Does a YAML roundtrip (dumpyaml-loadyaml) produce the same factor?''' 
    
    @classmethod
    def setUpClass(cls):
        _,cls.tempfile = tempfile.mkstemp()

    @classmethod
    def tearDownClass(cls):
        os.remove(cls.tempfile)
        
    def dumpnload(self,factor):
        s.dumpyaml(factor,self.tempfile)
        self.assertEqual(s.loadyaml(self.tempfile),factor)

    # ------------- TESTS -------------------

    def test_Multinom(self):
        f = s.Multinom.random('ABC',**doms)
        self.dumpnload(f)

    def test_Fun(self):
        f = s.Fun.random('C','AB',**doms)
        self.dumpnload(f)
    
    def test_SumProd(self):
        f = s.Multinom.random('AB',**doms)
        g = s.Multinom.random('BC',**doms)
        h = s.SumProd(['A'],[f,g])
        self.dumpnload(h)
    
    def test_Index(self):
        d = s.Fun.random('C','AB',**doms)
        f = s.Multinom.random('BCD',**doms)
        i = s.Index([d],[f])
        self.dumpnload(i)
    
    def test_Reorder(self):
        f = s.Multinom.random('ABC',**doms)
        r = s.Reorder([{'newB':'B'},{'newA':'A'},{'newC':'C'}],[f])
        self.dumpnload(r)
    
    def test_Embed(self):
        d = s.Fun.random('C','AB',**doms)
        e = s.Embed([d])
        self.dumpnload(e)
    
    def test_tree(self):
        f = s.Multinom.random('AD',**doms)
        d = s.Fun.random('D','B',**doms)
        i = s.Index([d],[f]) #AB
        g = s.Embed([s.Fun.random('B','C',**doms)])
        h = s.SumProd(['B'],[i,g]) #AC
        self.assertEqual(h.domlist,['A','C'])
        self.dumpnload(h)    


if __name__ == '__main__':
    unittest.main()


