import symfer as s
import numpy as np
import subprocess
import yaml
import tempfile
import os
import distutils.ccompiler

# need jsymfer in current dir for this -- TODO find a better place to stick it
def jsymfer(filename='tmp.yaml'):
   # subprocess.call(['java','-jar','jsymfer.jar',filename],shell=True)
    return subprocess.check_output('java -jar jsymfer.jar '+filename,shell=True)

def c3(fac,cfilename='tmp.c',binfilename='./tmp.out'):
    '''Old version, depends on gcc being on command line.'''
    s.dumpc(fac,cfilename)
    subprocess.check_call(['gcc',cfilename,'-o',binfilename])
    return s.Multinom(dom=s.makedom(fac.domlist,fac.domtypes),par=eval(subprocess.check_output(binfilename,shell=True)))

def c2(fac,cfilename='tmp.c',binfilename='./tmp.out'):
    s.dumpc(fac,cfilename)
    cc = distutils.ccompiler.new_compiler()
    ofilenames = cc.compile([cfilename])
    print(ofilenames)
    cc.link_executable(ofilenames,binfilename)
    return s.Multinom(dom=s.makedom(fac.domlist,fac.domtypes),par=eval(subprocess.check_output(binfilename)))    

def c(fac):
    tempdir = tempfile.mkdtemp()
    cfilename = 'tmp.c'
    binfilename = './tmp.out'
    wd = os.getcwd()
    os.chdir(tempdir)
    s.dumpc(fac,cfilename)
    cc = distutils.ccompiler.new_compiler()
    ofilenames = cc.compile([cfilename])
    cc.link_executable(ofilenames,binfilename)
    result = s.Multinom(dom=s.makedom(fac.domlist,fac.domtypes),par=eval(subprocess.check_output(binfilename)))
    os.remove(cfilename)
    os.remove(ofilenames[0])
    os.remove(binfilename)
    os.chdir(wd)
    os.rmdir(tempdir)
    return result

def list2dictlist(xs):
    return [{(x+'1'):x} for x in xs]

def allclose(m1,m2):
    return np.allclose(np.array(m1.par),np.array(m2.par),atol=1e-06)

m = s.Multinom.random('bcade',a=3,b=2,c=4,d=5,e=3)
domtypes = m.domtypes
domtypes['f']=range(4)
f1 = s.Fun.random('b','c',**domtypes)
f2 = s.Fun.random('a','dfc',**domtypes)
f3 = s.Fun.random('e','f',**domtypes)
ix = s.Index([f1,f2,f3],[m])
dictlist = list2dictlist(ix.domlist)
ix1 = s.Reorder(dictlist,[ix])
ix2 = s.Reorder(dictlist,[s.Index([f2],[s.Index([f3,f1],[m])])])
ix3 = s.Reorder(dictlist,[s.Index([f1,f3],[s.Index([f2],[m])])])
ix4 = s.Reorder(dictlist,[s.SumProd(list('bae'),[s.Embed([f1,f2,f3]),m])])

ixarr = s.evaluate(ix1)
print(ixarr.par == s.evaluate(ix2).par)
print(ixarr.par == s.evaluate(ix3).par)
print(ixarr.par == s.evaluate(ix4).par)
# see also np.allclose for comparing arrays with small differences

#print(s.evaluate(ix).arr)
#print(s.evaluate(ix2).arr)
#print(s.evaluate(ix3).arr)
#print(s.evaluate(ix4).arr)

s.dumpyaml(ix1)
javares = s.reconstruct(yaml.safe_load(jsymfer()))
print(allclose(ixarr,javares))
s.dumpyaml(ix2)
javares2 = s.reconstruct(yaml.safe_load(jsymfer()))
print(allclose(ixarr,javares2))
s.dumpyaml(ix3)
javares3 = s.reconstruct(yaml.safe_load(jsymfer()))
print(allclose(ixarr,javares3))
s.dumpyaml(ix4)
javares4 = s.reconstruct(yaml.safe_load(jsymfer()))
print(allclose(ixarr,javares4))

cres1 = c(ix1)
print(allclose(ixarr,cres1))
cres2 = c(ix2)
print(allclose(ixarr,cres2))
cres3 = c(ix3)
print(allclose(ixarr,cres3))
cres4 = c(ix4)
print(allclose(ixarr,cres4))


