import unittest
import symfer as s
import numpy as np

doms = {'A':2, 'B':3, 'C':5, 'D':3}

class TestFAEquations(unittest.TestCase):
    '''Does the implementation respect factor algebra?''' 
    
    def eqq(self,fac1,fac2):
        self.assertTrue(np.allclose(np.array(s.evaluate(fac1).par), np.array(s.evaluate(fac2).par)))
    
    # ------------- TESTS -------------------

    def test_Prod_Comm(self):
        f = s.Multinom.random('AB',**doms)
        g = s.Multinom.random('BC',**doms)
        self.eqq(
            f.product(g).reorder('ABC'),
            g.product(f).reorder('ABC')
            )
    
    def test_Prod_Iden_Left(self):
        f = s.Multinom.random('AB',**doms)
        self.eqq(
            s.SumProd([],[s.I(),f]), 
            f
            )

    def test_Prod_Iden_Right(self):
        f = s.Multinom.random('AB',**doms)
        self.eqq(
            s.SumProd([],[f,s.I()]), 
            f
            )
            
    def test_Prod_Empty(self):
        self.eqq(
            s.SumProd([],[]),
            s.I()
            )

    def test_Prod_Assoc(self):
        f = s.Multinom.random('AB',**doms)
        g = s.Multinom.random('BC',**doms)
        h = s.Multinom.random('CD',**doms)
        self.eqq(
            f.product(g).product(h),
            f.product(g.product(h))
            )
    
    def test_Distr_Left(self):
        f = s.Multinom.random('AB',**doms)
        g = s.Multinom.random('BC',**doms)
        self.eqq(
            f.product(g).sumout(['A']),
            f.sumout(['A']).product(g)
        )

    def test_Distr_Right(self):
        f = s.Multinom.random('AB',**doms)
        g = s.Multinom.random('BC',**doms)
        self.eqq(
            f.product(g).sumout(['C']),
            f.product(g.sumout(['C']))
        )
    
    def test_Sum_Comm(self):
        f = s.Multinom.random('ABC',**doms)
        self.eqq(
            s.SumProd(['A'],[s.SumProd(['B'],[f])]),
            s.SumProd(['B'],[s.SumProd(['A'],[f])])
        )
            
    def test_Sum_Collect(self):
        f = s.Multinom.random('ABC',**doms)
        self.eqq(
            s.SumProd(['A'],[s.SumProd(['B'],[f])]),
            s.SumProd(['A','B'],[f])
        )
    
    
        
    
"""
    def test_Fun(self):
        f = s.Fun.random('C','AB',**doms)
        self.dumpnload(f)
    
    def test_SumProd(self):
        f = s.Multinom.random('AB',**doms)
        g = s.Multinom.random('BC',**doms)
        h = s.SumProd(['A'],[f,g])
        self.dumpnload(h)
    
    def test_Index(self):
        d = s.Fun.random('C','AB',**doms)
        f = s.Multinom.random('BCD',**doms)
        i = s.Index([d],[f])
        self.dumpnload(i)
    
    def test_Reorder(self):
        f = s.Multinom.random('ABC',**doms)
        r = s.Reorder([{'newB':'B'},{'newA':'A'},{'newC':'C'}],[f])
        self.dumpnload(r)
    
    def test_Embed(self):
        d = s.Fun.random('C','AB',**doms)
        e = s.Embed([d])
        self.dumpnload(e)
    
    def test_tree(self):
        f = s.Multinom.random('AD',**doms)
        d = s.Fun.random('D','B',**doms)
        i = s.Index([d],[f]) #AB
        g = s.Embed([s.Fun.random('B','C',**doms)])
        h = s.SumProd(['B'],[i,g]) #AC
        self.assertEquals(h.domlist,['A','C'])
        self.dumpnload(h)    
"""

if __name__ == '__main__':
    unittest.main()


