#!/usr/bin/env python

from distutils.core import setup
import symfer_version

setup(name='symfer',
      version=symfer_version.__doc__,
      description='Symbolic probabilistic inference using factor algebra expressions',
      author='Sander Evers',
      author_email='sandr@dds.nl',
      url='http://mbsd.cs.ru.nl/symfer',
      packages=['symfer'],
      install_requires = [
        'PyYAML',
        'numpy',
        'pyparsing >= 1.5.2, <2',
        #'yapgvb',
        # --- removed because the default yapgvb installation requires Boost,
        #     and (1) yapgvb says that won't even work on Windows
        #     (2) we don't want to make Linux users install it just for drawing support
      ],
      scripts = [
        'bin/evaluate.py',
        'bin/ve_minweight.py',
      ],
      license='BSD 2-clause',
      platforms='Any',
      classifiers=[
        'License :: OSI Approved :: BSD License',
        ],
     )

