#!/usr/bin/env python

"""Numeric symfer evaluator script, using NumPy.

Usage (from command prompt):

evaluate.py factor.yaml

prints the resulting array. From within Python, use the loadyaml(filename) and
evaluate(factor) functions in the symfer package.
"""

import sys
import symfer as s

if __name__=='__main__':
    if len(sys.argv)>1:
        if sys.argv[1] in ('-h','-?','--help'):
            print(__doc__)
        else:
            filename = sys.argv[1]
            tree = s.loadyaml(filename)
            print('['+ ', '.join(str(prob) for prob in s.evaluate(tree).par) + ']')
    else:
        print __doc__

