from itertools import islice,tee
import datetime
import time
import sys

def printtime():
    print datetime.datetime.now().isoformat(' ')[:-4] # cut off after 1/100 sec

def product(it):
	'''Generalized product (product of all numbers in the iterable argument)'''
	it=iter(it)
	try:
	    p = it.next()
	except StopIteration:
	    p=1 # let's hope this is the unit element
	for i in it:
	    p*=i
	return p

def rflatten(lists,nr=-1):
    '''rflatten([[[1],[2]],[[3,4]]],3) yields 1,2,3,4'''
    if nr==0:
        yield lists
    elif nr>0: # MUST contain nr levels of lists
        it = iter(lists)
        for i in it:
            for ii in rflatten(i,nr-1):
                yield ii                   
    else: # don't care about structure, just see if you can iter
        try:
            it = iter(lists)
            for i in it:
                for ii in rflatten(i):
                    yield ii           
        except:
            yield lists

def normalize(xs,nr):
    '''split list in fragments of size nr, divide those fragments by their sum'''
    def gen():
        it = iter(xs)
        while 1:
            (frag1,frag2) = tee(islice(it,nr))
            s = sum(frag1)
            for _ in xrange(nr):
                yield frag2.next()/s
    return list(gen())

def identity(x):
    return x

def foldsh(tree,branch=lambda tree,ch:list(ch),leaf=identity,shared=identity,getchildren=iter):
    mem = dict()
    def _fold(tree):
        if id(tree) in mem:
            return shared(mem[id(tree)])
        else:
            try:
                children = getchildren(tree)
            except:
                res = leaf(tree)
            else:
                reschildren = [_fold(child) for child in children]
                res = branch(tree,reschildren)
            mem[id(tree)] = res
            return res
    return _fold(tree)

# Example:
# >>> nest(range(12),[2,2,3])
# [[[0, 1, 2], [3, 4, 5]], [[6, 7, 8], [9, 10, 11]]]
def nest(flat,levels):
    '''Turn a flat list into a nested list, with a specified number of lists per nesting level.'''
    return _nest(flat,levels).next()

def _nest(flat,levels):
    if levels:
        it = _nest(flat,levels[1:])
        while 1:
            yield list(islice(it,levels[0]))
    else:
        for d in flat:
            yield d

def repr_elems(s,divider=','):
    return divider.join(repr(elem) for elem in s)

def str_elems(s,divider=','):
    return divider.join(str(elem) for elem in s)

# adapted from http://bfroehle.com/2011/07/simple-timer/
class TicToc(object):
    """
    A simple code timer.
 
    Example
    -------
    >>> with TicToc():
    ...     time.sleep(2)
    Elapsed time is 2.000073 seconds.
    """
    def __init__(self, do_print = False):
        self.do_print = do_print
    def __enter__(self):
        self.start_time = time.time()
        return self
    def __exit__(self, type, value, traceback):
        self.elapsed = time.time() - self.start_time
        if self.do_print:
            print "Elapsed time is %f seconds." % self.elapsed
    def __str__(self):
        return '{0:.2f}s'.format(self.elapsed)

# from PEP 257, adapted with addindent
def trim(docstring,addindent=0):
    if not docstring:
        return ''
    # Convert tabs to spaces (following the normal Python rules)
    # and split into a list of lines:
    lines = docstring.expandtabs().splitlines()
    # Determine minimum indentation (first line doesn't count):
    indent = sys.maxint
    for line in lines[1:]:
        stripped = line.lstrip()
        if stripped:
            indent = min(indent, len(line) - len(stripped))
    # Remove indentation (first line is special):
    trimmed = [lines[0].strip()]
    if indent < sys.maxint:
        for line in lines[1:]:
            trimmed.append(line[indent:].rstrip())
    # Strip off trailing and leading blank lines:
    while trimmed and not trimmed[-1]:
        trimmed.pop()
    while trimmed and not trimmed[0]:
        trimmed.pop(0)
    # Return a single string:
    return ('\n'+' '*addindent).join(trimmed)

