from pyparsing import *
from itertools import islice,tee
from .utils import product,rflatten

def braced(x):
    return suplit('{') + x + suplit('}')

def parthed(x):
    return suplit('(') + x + suplit(')')

def supkeyw(x):
    return CaselessKeyword(x).suppress()

def suplit(x):
    return Literal(x).suppress()

# turn a function on a token into a parseAction
def liftToken(fn):
    def lifted(s,l,t):
        return [fn(t[0])]
    return lifted

# parseAction to return just the list rather than the parseElement
def asList(s,l,t):
    return t.asList()

probability = Combine(Word(nums) + Optional('.' + Word(nums)) + Optional(Word('eE',max=1) + Optional(Literal('-') + Word(nums)))) #.setParseAction(liftToken(float))
nodename = Word(alphas+'_',alphanums+'_')
keyval = (
    Group(CaselessKeyword('states') + suplit('=') + parthed(Group(ZeroOrMore(quotedString.setParseAction(removeQuotes)))).setParseAction(asList) + suplit(';'))
    | Group(CaselessKeyword('label') + suplit('=') + suplit('"') + nodename + suplit('"') + suplit(';'))
    | Group(Word(alphas+'_',alphanums+'_') + suplit('=') + SkipTo(suplit(';'),include=True,ignore=quotedString))
    )
keyvals = Dict(ZeroOrMore(keyval))

node = Group(
    CaselessKeyword('node')
#    + Dict(Group(nodename + braced(keyvals))) # node definitions go directly to result dict, OR:
    + Group(nodename('name') + braced(keyvals))   # for symmetry with potential
    )

data = nestedExpr(content=probability).setParseAction(asList)
potential = \
    Group(
        CaselessKeyword('potential')
        + Group(
            parthed( nodename('child') + Group(Optional(suplit('|') + ZeroOrMore(nodename)))('parents') )
            + braced( supkeyw('data') + suplit('=') + data('data') + suplit(';') )
          )
    )
net = supkeyw('net')+braced(SkipTo('}',ignore=quotedString).suppress())
bn = ZeroOrMore(net | node | potential)
mClass = supkeyw('class') + nodename.suppress() + braced(bn) | bn

stripComments = Combine(ZeroOrMore(SkipTo('%'|lineEnd,ignore=quotedString)+SkipTo(lineEnd).suppress()+lineEnd))
            
def parseFile(filename='parse.tmp'):
    stripped = stripComments.parseFile(filename)
    parsed = mClass.parseString(stripped[0])

    cpds={} # cpd['childname'] = {'states':['aap','noot'], 'parents':['par1','par2'], 'data':['1','2','3','4','5','6','7','8']}
    for typ,contents in parsed:
        if typ=='node':
            elt = {}
            elt['states'] = contents.states
            if hasattr(contents,'label'):
                elt['label'] = contents.label
            cpds[contents.name] = elt
        elif typ=='potential':
            elt = cpds[contents.child]
            elt['parents'] = contents.parents.asList()
            dims = [len(cpds[p]['states']) for p in elt['parents']]+[len(elt['states'])]
            data = contents.data.asList()
            if len(data)==dims[0]: #nested, so unnest
                data = list(rflatten(data,len(dims)))
            if len(data)!=product(dims):
                raise Exception('{0}: data not ok: {1} items, {2} expected.'.format(contents.child,len(data),product(dims)))
            elt['data'] = data
    
    return cpds




