#!/usr/bin/env python

"""Symfer variable elimination.

Reads a Hugin (*.net) file, uses symfer's ve_minweight function to do
inference, and saves the resulting factor algebra expression to a .yaml file.

Usage (from command prompt):

ve_minweight.py model.net target_variable inference.yaml

where target_variable is replaced by the Hugin variable name.
"""

import sys
import symfer as s

if __name__=='__main__':
    if len(sys.argv)==2 and sys.argv[1] in ('-h','-?','--help'):
        print __doc__
    elif len(sys.argv)==4:
        huginfilename = sys.argv[1]
        variable = sys.argv[2]
        yamlfilename = sys.argv[3]
        model = s.loadhugin(huginfilename)
        ve = s.ve_minweight(model,[variable])
        s.dumpyaml(ve,yamlfilename)
    else:
        print __doc__

